<?php $__env->startPush('content'); ?>
    <!-- Main content -->
    <section class="content">
        <!-- SELECT2 EXAMPLE -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title">Create  Plan</h3>

                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                    <button type="button" class="btn btn-box-tool" data-widget="remove"><i
                            class="fa fa-remove"></i></button>
                </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <!-- Validation Error Display -->
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('admin.Plans.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <div class="row">

                        <div class="col-md-6">
                            <!-- Plan Name -->
                            <div class="form-group">
                                <label for="Plan_name">Name</label>
                                <input type="text" class="form-control" name="Plan_name" required>
                            </div>

                            <!-- Plan Description -->
                            <div class="form-group">
                                <label for="Plan_description">Description</label>
                                <textarea class="form-control" name="Plan_description" required></textarea>
                            </div>

                             <!-- Image upload -->
                             <div class="form-group">
                                <label for="Plan_image">Plan Image</label>
                                <input type="file" name="Plan_image" class="form-control" accept="image/*" required>
                            </div>


                        </div>


                        <div class="col-md-6">
                            <!-- Plan Price in USD -->
                            <div class="form-group">
                                <label for="Plan_price_usd">Price (in USD)</label>
                                <input type="text" class="form-control" name="Plan_price_usd" id="Plan_price_usd"
                                     required>
                            </div>

                            <!-- Plan Price in ETH (Calculated) -->
                            <div class="form-group">
                                <label for="Plan_price">Price (in ETH)</label>
                                <input type="text" class="form-control" name="Plan_price" id="Plan_price"
                                   readonly required>
                            </div>
                            <!-- Category selection -->
                            <div class="form-group">
                                <label for="Plan_category_id">Category</label>
                                <select name="Plan_category_id" class="form-control" required>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->category_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <!-- User selection -->
                            <div class="form-group">
                                <label for="user_id">User</label>
                                <select name="user_id" class="form-control" required>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>


                        </div>

                    </div>
                    <!-- /.row -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <div class="col-md-6">
                    <button type="submit" class="btn btn-primary">Create Plan</button>
                </div>
            </div>
            </form>
        </div>

    </section>
    <!-- /.box -->

    <script>
        // This value should come from the server (passed from the controller)
        let ethPriceInUsd = <?php echo e($ethPrice ?? 0); ?>; // ETH price in USD

        document.getElementById('Plan_price_usd').addEventListener('input', function() {
            let usdPrice = parseFloat(this.value);
            if (!isNaN(usdPrice) && ethPriceInUsd > 0) {
                // Calculate ETH price
                let ethPrice = usdPrice / ethPriceInUsd;
                document.getElementById('Plan_price').value = ethPrice.toFixed(
                6); // Display ETH price with 6 decimal places
            } else {
                document.getElementById('Plan_price').value = ''; // Clear ETH price if input is invalid
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/user/Documents/Developement/blocktraderinvestments/resources/views/admin/Plans/create.blade.php ENDPATH**/ ?>